﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class ExerciseDataTable : DataTable
    {
        public ExerciseDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("TOTAL_STEPS", typeof(int)));
            this.Columns.Add(new DataColumn("DATE", typeof(string)));
        }

        public ExerciseDataRow this[int index]
        {
            get
            {
                return (ExerciseDataRow)Rows[index];
            }
        }

        public void Add(ExerciseDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(ExerciseDataRow row)
        {
            this.Rows.Remove(row);
        }

        public ExerciseDataRow GetNewRow()
        {
            ExerciseDataRow row = (ExerciseDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(ExerciseDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new ExerciseDataRow(builder);
        }

        public IEnumerator<ExerciseDataRow> GetEnumerator()
        {
            List<ExerciseDataRow> rows = new List<ExerciseDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((ExerciseDataRow)this.Rows[i]);
            }

            return rows.GetEnumerator();
        }
    }
}
